########################################################################
# Copyright (C) 2010 - 2016 VMWare, Inc.
# All Rights Reserved
########################################################################

"""'Misc utility functions
"""
import sys

def isPython3OrLater():
   """Return True if pyhton 3.0 or newer.
   """
   return sys.version_info[0] >= 3

def isString(objInstance):
   """Check whether the given object is a string.
   """
   if isPython3OrLater():
      return isinstance(objInstance, str)
   else:
      return isinstance(objInstance, basestring)

def byteToStr(byteString):
   """Convert an ascii byte string into a python native string.
   """
   return "".join(['%c' % c for c in byteString])

def isSeekSupported(fileInstance):
   """Check whether a file object supports '.seek()'
   """
   # Python file object will raise in seek() truncate() tell()
   # when seek is unsupported, we use tell() to safely check if seek() works
   try:
      _ = fileInstance.tell()
   except:
      return False
   else:
      return True

