import os
import sys

def Configure(**kwargs):
   """This function is used to configure various aspects of the module's
      operation. The following keyword arguments are accepted:
         * nettimeout   - A positive integer or float giving the amount of time
                          to wait for reads from a connection to an HTTP, HTTPS
                          or FTP server. May also be None or 0, which disables
                          the timeout.
         * netretries   - A positive integer specifying the number of times to
                          retry a connection to an HTTP, HTTPS or FTP server.
                          A value of 0 causes infinite retries. This may also
                          be None, which disables retrying.
         * netratelimit - A positive integer specifying, in bytes per second,
                          the maximum bandwidth to use for HTTP, HTTPS and FTP
                          downloads.
         * certsdir     - Specifies a path to a directory containing the
                          certificates to be used for acceptance level
                          verification.
         * schemadir    - Specifies a path to a directory containing the
                          schemas to be used for acceptance level verification.
   """
   if "nettimeout" in kwargs:
      from . import Downloader
      Downloader.SetTimeout(kwargs.pop("nettimeout"))
   if "netretries" in kwargs:
      from . import Downloader
      Downloader.SetRetry(kwargs.pop("netretries"))
   if "netratelimit" in kwargs:
      from . import Downloader
      Downloader.SetRateLimit(kwargs.pop("netratelimit"))

   al_args = dict()
   for key in ("certsdirs", "schemadir"):
      if key in kwargs:
         al_args[key] = kwargs.pop(key)

   if al_args:
      from . import AcceptanceLevels
      AcceptanceLevels.Initialize(**al_args)

   if kwargs:
      raise TypeError("configure() got unexpected keyword argument(s): %s"
                      % ", ".join(kwargs))
